declare default element namespace 'http://пф.рф/ВС/СЗВ-М/2016-01-01';declare namespace УТ = "http://пф.рф/унифицированныеТипы/2014-01-01";
declare namespace АФ = "http://пф.рф/АФ";
declare variable $document as node()* external;
declare variable $root:=root($document)/ЭДПФР;
declare variable $szv:=$root/СЗВ-М;
declare function local:nodeIndex($nodes as node()*, $nodeToFind as node()) as xs:integer
{

				for $seq in (1 to count($nodes))
				return $seq[$nodes[$seq] is $nodeToFind]
			
};
declare function local:nodePosition($node as node()?) as xs:string
{

				string-join(
					for $ancestor in $node/ancestor-or-self::*
					let $sibsOfSameName := $ancestor/../*[name()=name($ancestor)]
					return concat(name($ancestor),
						if (count($sibsOfSameName)<= 1) then '' else concat('[',local:nodeIndex($sibsOfSameName,$ancestor),']')),
						'/'
				)
			
};
declare function local:all-whitespace($arg as xs:string?) as xs:boolean
{

				normalize-space($arg) = ''
			
};
declare function local:isEmpty($element) as xs:boolean
{

				local:all-whitespace(string($element))
			
};
declare function local:notExistsOrEmpty($element) as xs:boolean
{

				not(exists($element)) or local:isEmpty($element)
			
};
<БлокПроверок ID="ВСЗЛ.СЗВ-М.1" name="Блок проверок реестр застрахованных лиц">
<Проверка ID="1">
<Описание>Поле 'Номер по порядку' должно быть заполнено в порядке возрастания без пропусков и повторений</Описание>
<РезультатЗапроса>
{
				let $seq := $szv/СписокЗЛ/ЗЛ
				for $zl in $seq
					let $pos := local:nodeIndex($seq, $zl)
					return if ($pos != local:nodeIndex($seq, $seq[last()])) then
						if ((number($zl/@НомерПП) + 1) = number($seq[$pos + 1]/@НомерПП)) then '0'
						else local:nodePosition($seq[$pos + 1])
					else '0'
			}
</РезультатЗапроса>
<КодРезультата>30</КодРезультата>
</Проверка>
<Проверка ID="2">
<Описание>Элемент ИНН застрахованного лица должен быть заполнен</Описание>
<РезультатЗапроса>
{
				for $zl in $szv/СписокЗЛ/ЗЛ
					return if (not(local:notExistsOrEmpty($zl/ИНН))) then '0'
					else local:nodePosition($zl)
			}
</РезультатЗапроса>
<КодРезультата>20</КодРезультата>
</Проверка>
</БлокПроверок>

